<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class FeeTransaction extends Model
{
    protected $table = 'fees_transactions';
    protected $primaryKey = 'FT_Id';
    public $timestamps = true;

    protected $fillable = [
        'Ft_Date',
        'SocId',
        'Ft_VouTy',
        'Ft_VouNo',
        'Ft_SrNo',
        'AccId',
        'FC_ID',
        'SU_Id',
        'Chq_No',
        'Chq_Dt',
        'Cr_Amount',
        'Dr_Amount',
        'Ref_VouNo',
        'Approved_By',
        'Approved_Date',
        'Description',
    ];

    protected $casts = [
        'Ft_Date' => 'datetime',
        'Chq_Dt' => 'date',
        'Approved_Date' => 'date',
        'Cr_Amount' => 'decimal:2',
        'Dr_Amount' => 'decimal:2',
    ];

    public function getFtDateAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('Y-m-d H:i:s') : null;
    }

    public function setFtDateAttribute($value)
    {
        $this->attributes['Ft_Date'] = $value ? Carbon::parse($value) : null;
    }

    public function getChqDtAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('Y-m-d') : null;
    }

    public function setChqDtAttribute($value)
    {
        $this->attributes['Chq_Dt'] = $value ? Carbon::parse($value) : null;
    }

    public function getApprovedDateAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('Y-m-d') : null;
    }

    public function setApprovedDateAttribute($value)
    {
        $this->attributes['Approved_Date'] = $value ? Carbon::parse($value) : null;
    }

    public function feeConfig()
    {
        return $this->belongsTo(FeeConfig::class, 'FC_ID', 'FC_Id');
    }

    public function socUnit()
    {
        return $this->belongsTo(SocUnit::class, 'SU_Id', 'SU_ID')->withDefault();
    }

    public function society()
    {
        return $this->belongsTo(SocietyMaster::class, 'SocId', 'SocId');
    }

    public function account()
    {
        return $this->belongsTo(PrtyMast::class, 'AccId', 'Pr_Id')->withDefault();
    }
}
