<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class FeeConfig extends Model
{
    protected $table = 'fees_config';
    protected $primaryKey = 'FC_Id';
    public $timestamps = true;

    protected $fillable = [
        'Fs_Id',
        'SocId',
        'SU_ID',
        'Start_Date',
        'Due_Date',
        'Status',
        'Amount',
        'Per_Uni_Type',
        'Frequency',
        'EB_Disc',
        'EB_Days',
        'Blk_Payment',
        'Blk_Units',
        'Spl_Cate',
        'Late_Charges',
        'Interest_Charges',
        'Int_Chg_Unit',
        'IncId',
        'RecId',
    ];

    protected $casts = [
        'Start_Date' => 'date',
        'Due_Date' => 'date',
    ];

    public function getStartDateAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d/m/Y') : null;
    }

    public function setStartDateAttribute($value)
    {
        $this->attributes['Start_Date'] = $value
            ? Carbon::createFromFormat('d/m/Y', $value)
            : null;
    }

    public function getDueDateAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d/m/Y') : null;
    }

    public function setDueDateAttribute($value)
    {
        $this->attributes['Due_Date'] = $value
            ? Carbon::createFromFormat('d/m/Y', $value)
            : null;
    }

    public function fee()
    {
        return $this->belongsTo(Fee::class, 'Fs_Id', 'Fs_Id');
    }

    public function society()
    {
        return $this->belongsTo(SocietyMaster::class, 'SocId', 'SocId');
    }

    public function socUnit()
    {
        return $this->belongsTo(SocUnit::class, 'SU_ID', 'SU_ID');
    }
}
