<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DiscountMaster extends Model
{
    use HasFactory;

    protected $primaryKey = 'DiscID';

    protected $fillable = [
        'DiscTID',
        'DiscountName',
        'DiscCriID',
        'Cri_Vale',
        'Disc_Value',
        'DiscCMast',
        'DiscUId',
        'D_Valid_From',
        'D_Valid_To',
        'D_Apply_To',
        'Disc_Clubbed',
        'Status',
    ];

    public function discountType()
    {
        return $this->belongsTo(DiscountType::class, 'DiscTID', 'DiscTID');
    }

    public function discountCriteria()
    {
        return $this->belongsTo(DiscCrieteria::class, 'DiscCriID', 'DiscCriID');
    }

    public function discountCondition()
    {
        return $this->belongsTo(DiscCondMast::class, 'DiscCMast', 'DiscCMast');
    }

    public function discountUnit()
    {
        return $this->belongsTo(DiscUnit::class, 'DiscUId', 'DiscUID');
    }
}
