<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Carbon\Carbon;

class ComplaintBook extends Model
{
    protected $table = 'complaint_books';  // Define the table name
    protected $primaryKey = 'Cmp_Id';      // Define the primary key
    public $timestamps = true;             // Enable timestamps

    // Fillable fields for mass assignment
    protected $fillable = [
        'CC_Id', 'SocId', 'U_Id', 'Title', 'Description', 'CompType', 'Severity', 'Status', 'InProgre_At', 'Complited_At', 'CompMode'
    ];

    // Cast timestamps to a specific format
    protected $casts = [
        'InProgre_At' => 'datetime:Y-m-d H:i:s',
        'Complited_At' => 'datetime:Y-m-d H:i:s',
        'created_at' => 'datetime:Y-m-d H:i:s',
        'updated_at' => 'datetime:Y-m-d H:i:s',
    ];

    // Define relationships
    public function category()
    {
        return $this->belongsTo(CompCategory::class, 'CC_Id', 'CC_Id');
    }

    public function society()
    {
        return $this->belongsTo(SocietyMaster::class, 'SocId', 'SocId');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'U_Id', 'U_Id');
    }
}
