<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CompGallary extends Model
{
    protected $table = 'comp_gallary';  // Table name
    protected $primaryKey = 'Cg_Id';  // Primary key
    public $timestamps = true;  // Enable timestamps

    protected $fillable = ['Cmp_Id', 'Image', 'Img_Date', 'U_Id', 'Img_Status'];

    // Cast images field to array
    protected $casts = [
        'Image' => 'array',
    ];

    // Define relationships
    public function complaint()
    {
        return $this->belongsTo(ComplaintBook::class, 'Cmp_Id', 'Cmp_Id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'U_Id', 'U_Id');
    }
}



