<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompActionLog extends Model
{
    use HasFactory;

    protected $table = 'comp_action_log';
    protected $primaryKey = 'CA_Sr';
    protected $fillable = ['Cmp_Id', 'Act_U_ID', 'CA_ID', 'Ca_Desc'];

    // Define relationships
    public function complaint()
    {
        return $this->belongsTo(ComplaintBook::class, 'Cmp_Id', 'Cmp_Id');
    }

    public function actionUser()
    {
        return $this->belongsTo(User::class, 'Act_U_ID', 'U_Id');
    }

    public function compAction()
    {
        return $this->belongsTo(CompAction::class, 'CA_ID', 'CA_ID');
    }
}
