<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClassiGallary extends Model
{
    use HasFactory;

    protected $table = 'classi_gallary';
    protected $primaryKey = 'Clg_Id';
    public $timestamps = true;

    protected $fillable = ['FLC_Id', 'Image', 'Img_Date', 'Img_U_Id', 'Img_Status'];

    protected $casts = [
        'Image' => 'array',
    ];

    public function freeLClasssified()
    {
        return $this->belongsTo(FreeLClasssified::class, 'FLC_Id', 'FLC_Id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'Img_U_Id', 'U_Id');
    }
}
