<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AmenityGallary extends Model
{
    use HasFactory;

    protected $table = 'amenity_gallary';
    protected $primaryKey = 'AG_Id';
    public $timestamps = true;

    protected $fillable = ['AM_ID', 'Image', 'Img_Date', 'Img_U_Id', 'Img_Status'];

    protected $casts = [
        'Image' => 'array',
    ];

    public function amenity()
    {
        return $this->belongsTo(AmenityMaster::class, 'AM_ID', 'AM_ID');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'Img_U_Id', 'U_Id');
    }
}

