<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AmenityConfig extends Model
{
    use HasFactory;

    protected $table = 'amenity_configs';
    protected $primaryKey = 'AC_ID';
    protected $fillable = ['AM_ID', 'SocId', 'FC_Id', 'Name', 'MaxCapacity', 'Status', 'TimeSlot', 'FeesUnit'];

    public function amenity()
    {
        return $this->belongsTo(AmenityMaster::class, 'AM_ID', 'AM_ID');
    }

    public function society()
    {
        return $this->belongsTo(SocietyMaster::class, 'SocId', 'SocId');
    }

    public function feesConfig()
    {
        return $this->belongsTo(FeeConfig::class, 'FC_Id', 'FC_Id');
    }
}
