<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AmenityBooking extends Model
{
    use HasFactory;

    protected $table = 'amenity_bookings';
    protected $primaryKey = 'AB_ID';
    protected $fillable = [
        'AC_ID', 'U_Id', 'StartDateTime', 'EndDateTime', 'QtyRequested', 'QtyBooked',
        'Amount', 'EB_Disc', 'Blk_Disc', 'Spl_Cat_Disc', 'Late_Chg', 'Int_Chg',
        'Req_Date', 'Approved_By', 'Approved_Date'
    ];

    public function amenityConfig()
    {
        return $this->belongsTo(AmenityConfig::class, 'AC_ID', 'AC_ID');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'U_Id', 'U_Id');
    }

    public function approver()
    {
        return $this->belongsTo(User::class, 'Approved_By', 'U_Id');
    }
}

