<?php

namespace App\Http\Controllers;

use App\Models\SubFinanTrn;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class SubFinanTrnController extends Controller
{
    public function index()
    {
        return response()->json(SubFinanTrn::with(['finanTrn', 'coMaster', 'branchM'])->get(), 200);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'Co_Id' => 'required|integer|exists:co_masters,Co_Id',
            'Br_Id' => 'required|integer|exists:branch_ms,Br_Id',
            'Ft_Id' => 'required|integer|exists:finan_trns,Ft_Id',
            'vou_ty' => 'required|string|max:3',
            'vou_id' => 'required|integer',
            'vou_sr' => 'required|integer',
            'vou_ln' => 'required|integer',
            'sub_sr_no' => 'required|integer',
            'inst_no' => 'nullable|numeric',
            'agt_amt' => 'nullable|numeric',
            'chq_no' => 'nullable|string|max:12',
            'pymt_dt' => 'nullable|date',
            'op_id' => 'nullable|integer',
            'dt_tm' => 'nullable|string|max:10',
            'ag_id' => 'nullable|string|max:50',
            'in_no' => 'nullable|numeric',
            'inq_id' => 'nullable|integer',
            'chq_ret' => 'nullable|numeric',
            'loan_incom' => 'nullable|numeric',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $subFinanTrn = SubFinanTrn::create($request->all());
        return response()->json($subFinanTrn->load(['finanTrn', 'coMaster', 'branchM']), 201);
    }

    public function show($id)
    {
        $subFinanTrn = SubFinanTrn::with(['finanTrn', 'coMaster', 'branchM'])->findOrFail($id);
        return response()->json($subFinanTrn, 200);
    }

    public function update(Request $request, $id)
    {
        $subFinanTrn = SubFinanTrn::findOrFail($id);
        $validator = Validator::make($request->all(), [
            'Co_Id' => 'required|integer|exists:co_masters,Co_Id',
            'Br_Id' => 'required|integer|exists:branch_ms,Br_Id',
            'Ft_Id' => 'required|integer|exists:finan_trns,Ft_Id',
            'vou_ty' => 'required|string|max:3',
            'vou_id' => 'required|integer',
            'vou_sr' => 'required|integer',
            'vou_ln' => 'required|integer',
            'sub_sr_no' => 'required|integer',
            'inst_no' => 'nullable|numeric',
            'agt_amt' => 'nullable|numeric',
            'chq_no' => 'nullable|string|max:12',
            'pymt_dt' => 'nullable|date',
            'op_id' => 'nullable|integer',
            'dt_tm' => 'nullable|string|max:10',
            'ag_id' => 'nullable|string|max:50',
            'in_no' => 'nullable|numeric',
            'inq_id' => 'nullable|integer',
            'chq_ret' => 'nullable|numeric',
            'loan_incom' => 'nullable|numeric',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $subFinanTrn->update($request->all());
        return response()->json($subFinanTrn->load(['finanTrn', 'coMaster', 'branchM']), 200);
    }

    public function destroy($id)
    {
        $subFinanTrn = SubFinanTrn::findOrFail($id);
        $subFinanTrn->delete();
        return response()->json(null, 204);
    }
}
