<?php

namespace App\Http\Controllers;

use App\Models\ServiceCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ServiceCategoryController extends Controller
{
    // Get all service categories
    public function index()
    {
        $categories = ServiceCategory::all();
        return response()->json($categories, 200);
    }

    // Get single service category by ID
    public function show($id)
    {
        $category = ServiceCategory::find($id);
        if (!$category) {
            return response()->json(['message' => 'Category Not Found'], 404);
        }
        return response()->json($category, 200);
    }

    // Store a new service category
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'srv_desc' => 'required|string|max:100',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $category = ServiceCategory::create([
            'srv_desc' => $request->srv_desc
        ]);

        return response()->json($category, 201);
    }

    // Update an existing service category
    public function update(Request $request, $id)
    {
        $category = ServiceCategory::find($id);
        if (!$category) {
            return response()->json(['message' => 'Category Not Found'], 404);
        }

        $validator = Validator::make($request->all(), [
            'srv_desc' => 'required|string|max:100',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $category->update([
            'srv_desc' => $request->srv_desc
        ]);

        return response()->json($category, 200);
    }

    // Delete a service category
    public function destroy($id)
    {
        $category = ServiceCategory::find($id);
        if (!$category) {
            return response()->json(['message' => 'Category Not Found'], 404);
        }

        $category->delete();
        return response()->json(['message' => 'Category Deleted Successfully'], 200);
    }
}
