<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\ScoPackage;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Validator;

class ScoPackageController extends Controller
{
    public function index(): JsonResponse
    {
        $scoPackages = ScoPackage::with(['society', 'package'])->get();
        return response()->json(['data' => $scoPackages], 200);
    }

    public function store(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'SocId' => 'required|exists:society_master,SocId',
            'PackageId' => 'required|exists:package_masters,PackageId',
            'Start_Date' => 'required|date_format:Y-m-d',
            'Valid_Date' => 'required|date_format:Y-m-d|after:Start_Date',
            'Status' => 'required|string|in:A,I|max:1',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'errors' => $validator->errors(),
                'message' => 'Validation failed'
            ], 422);
        }

        $scoPackage = ScoPackage::create($validator->validated());
        return response()->json(['data' => $scoPackage, 'message' => 'Society Package created successfully'], 201);
    }

    public function show($id): JsonResponse
    {
        $scoPackage = ScoPackage::with(['society', 'package'])->findOrFail($id);
        return response()->json(['data' => $scoPackage], 200);
    }

    public function update(Request $request, $id): JsonResponse
    {
        $scoPackage = ScoPackage::findOrFail($id);

        $validator = Validator::make($request->all(), [
            'SocId' => 'required|exists:society_master,SocId',
            'PackageId' => 'required|exists:package_masters,PackageId',
            'Start_Date' => 'required|date_format:Y-m-d',
            'Valid_Date' => 'required|date_format:Y-m-d|after:Start_Date',
            'Status' => 'required|string|in:A,I|max:1',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'errors' => $validator->errors(),
                'message' => 'Validation failed'
            ], 422);
        }

        $scoPackage->update($validator->validated());
        return response()->json(['data' => $scoPackage, 'message' => 'Society Package updated successfully'], 200);
    }

    public function destroy($id): JsonResponse
    {
        $scoPackage = ScoPackage::findOrFail($id);
        $scoPackage->delete();
        return response()->json(['message' => 'Society Package deleted successfully'], 200);
    }
}
