<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\ScoDiscMap;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Validator;

class ScoDiscMapController extends Controller
{
    public function index(): JsonResponse
    {
        $scoDiscMaps = ScoDiscMap::with(['society', 'discount'])->get();
        return response()->json(['data' => $scoDiscMaps], 200);
    }

    public function store(Request $request): JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'SocId' => 'required|exists:society_master,SocId',
            'DiscID' => 'required|exists:discount_masters,DiscID',
            'Start_Date' => 'required|date_format:Y-m-d',
            'Valid_Date' => 'required|date_format:Y-m-d|after:Start_Date',
            'Status' => 'required|string|in:A,I|max:1',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'errors' => $validator->errors(),
                'message' => 'Validation failed'
            ], 422);
        }

        $scoDiscMap = ScoDiscMap::create($validator->validated());
        return response()->json(['data' => $scoDiscMap, 'message' => 'Society Discount Mapping created successfully'], 201);
    }

    public function show($id): JsonResponse
    {
        $scoDiscMap = ScoDiscMap::with(['society', 'discount'])->findOrFail($id);
        return response()->json(['data' => $scoDiscMap], 200);
    }

    public function update(Request $request, $id): JsonResponse
    {
        $scoDiscMap = ScoDiscMap::findOrFail($id);

        $validator = Validator::make($request->all(), [
            'SocId' => 'required|exists:society_master,SocId',
            'DiscID' => 'required|exists:discount_masters,DiscID',
            'Start_Date' => 'required|date_format:Y-m-d',
            'Valid_Date' => 'required|date_format:Y-m-d|after:Start_Date',
            'Status' => 'required|string|in:A,I|max:1',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'errors' => $validator->errors(),
                'message' => 'Validation failed'
            ], 422);
        }

        $scoDiscMap->update($validator->validated());
        return response()->json(['data' => $scoDiscMap, 'message' => 'Society Discount Mapping updated successfully'], 200);
    }

    public function destroy($id): JsonResponse
    {
        $scoDiscMap = ScoDiscMap::findOrFail($id);
        $scoDiscMap->delete();
        return response()->json(['message' => 'Society Discount Mapping deleted successfully'], 200);
    }
}
