<?php

namespace App\Http\Controllers;

use App\Models\RelationMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class RelationMasterController extends Controller
{
    public function index()
    {
        $relationMasters = RelationMaster::all();
        return response()->json([
            'status' => 'success',
            'message' => 'Relation masters retrieved successfully',
            'data' => $relationMasters
        ], 200);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'MemRel_Desc' => 'required|string|max:25',
        ], [
            'MemRel_Desc.required' => 'The relation description is required.',
            'MemRel_Desc.string' => 'The relation description must be a string.',
            'MemRel_Desc.max' => 'The relation description may not be greater than 25 characters.',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Validation failed',
                'errors' => $validator->errors()
            ], 422);
        }

        try {
            $data = $validator->validated();
            $relationMaster = RelationMaster::create($data);
            return response()->json([
                'status' => 'success',
                'message' => 'Relation master created successfully',
                'data' => $relationMaster
            ], 201);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'An unexpected error occurred while creating the relation master: ' . $e->getMessage()
            ], 500);
        }
    }

    public function show($id)
    {
        $relationMaster = RelationMaster::find($id);
        if (!$relationMaster) {
            return response()->json([
                'status' => 'error',
                'message' => 'Relation master not found'
            ], 404);
        }

        return response()->json([
            'status' => 'success',
            'message' => 'Relation master retrieved successfully',
            'data' => $relationMaster
        ], 200);
    }

    public function update(Request $request, $id)
    {
        $relationMaster = RelationMaster::find($id);
        if (!$relationMaster) {
            return response()->json([
                'status' => 'error',
                'message' => 'Relation master not found'
            ], 404);
        }

        $validator = Validator::make($request->all(), [
            'MemRel_Desc' => 'required|string|max:25',
        ], [
            'MemRel_Desc.required' => 'The relation description is required.',
            'MemRel_Desc.string' => 'The relation description must be a string.',
            'MemRel_Desc.max' => 'The relation description may not be greater than 25 characters.',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Validation failed',
                'errors' => $validator->errors()
            ], 422);
        }

        try {
            $data = $validator->validated();
            $relationMaster->update($data);
            return response()->json([
                'status' => 'success',
                'message' => 'Relation master updated successfully',
                'data' => $relationMaster
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'An unexpected error occurred while updating the relation master.'
            ], 500);
        }
    }

    public function destroy($id)
    {
        $relationMaster = RelationMaster::find($id);
        if (!$relationMaster) {
            return response()->json([
                'status' => 'error',
                'message' => 'Relation master not found'
            ], 404);
        }

        try {
            $relationMaster->delete();
            return response()->json([
                'status' => 'success',
                'message' => 'Relation master deleted successfully'
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'An unexpected error occurred while deleting the relation master.'
            ], 500);
        }
    }
}
