<?php

namespace App\Http\Controllers;

use App\Models\PrtyMast;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PrtyMastController extends Controller
{
    public function index()
    {
        return response()->json(PrtyMast::with(['coMaster', 'branchM'])->get(), 200);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'Co_Id' => 'required|integer|exists:co_masters,Co_Id',
            'Br_Id' => 'required|integer|exists:branch_ms,Br_Id',
            'pr_code' => 'nullable|string|max:15',
            'pr_gr' => 'nullable|string|max:8',
            'an_id' => 'nullable|string|max:40',
            'pr_ct_id' => 'nullable|string|max:40',
            'pr_td_id' => 'nullable|string|max:40',
            'pr_fb_id' => 'nullable|string|max:40',
            'pr_bk_id' => 'nullable|string|max:40',
            'pr_name' => 'nullable|string|max:40',
            'pr_ad_pr_no' => 'nullable|string|max:7',
            'pr_ad_pr_nm' => 'nullable|string|max:20',
            'pr_ad_nr_lm' => 'nullable|string|max:20',
            'pr_ad_strt' => 'nullable|string|max:20',
            'pr_ar_id' => 'nullable|string|max:20',
            'pr_eml' => 'nullable|email|max:35',
            'pr_web' => 'nullable|url|max:35',
            'pr_ph' => 'nullable|string|max:35',
            'pr_cp' => 'nullable|string|max:35',
            'pr_ref' => 'nullable|string|max:30',
            'pr_hld' => 'nullable|string|max:1',
            'pr_rmk' => 'nullable|string|max:30',
            'pr_cr_l' => 'nullable|numeric',
            'pr_dp' => 'nullable|numeric',
            'pr_cr_d' => 'nullable|numeric',
            'pnl_int' => 'nullable|numeric',
            'pr_bl_p' => 'nullable|string|max:1',
            'pr_rpt' => 'nullable|string|max:1',
            'cq_clr' => 'nullable|numeric',
            'pr_st' => 'nullable|string|max:35',
            'pr_cst' => 'nullable|string|max:35',
            'pr_vat' => 'nullable|string|max:35',
            'pr_pa' => 'nullable|string|max:35',
            'pr_reg' => 'nullable|string|max:35',
            'pr_ecx' => 'nullable|string|max:35',
            'pr_ecc' => 'nullable|string|max:35',
            'pr_e_ad' => 'nullable|string|max:35',
            'pr_e_dv' => 'nullable|string|max:35',
            'pr_e_col' => 'nullable|string|max:35',
            'pr_e_rng' => 'nullable|string|max:35',
            'pr_e_ra1' => 'nullable|string|max:35',
            'pr_trn' => 'nullable|string|max:20',
            'pr_sub' => 'nullable|string|max:1',
            'tallydata' => 'nullable|string|max:50',
            'sn_func_id' => 'nullable|numeric',
            'sb_func' => 'nullable|string|max:20',
            'pr_bl_t' => 'nullable|string|max:1',
            'op_id' => 'nullable|integer',
            'dt_tm' => 'nullable|string|max:10',
            'opb_amt' => 'nullable|numeric',
            'cur_amt' => 'nullable|numeric',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $prtyMast = PrtyMast::create($request->all());
        return response()->json($prtyMast->load(['coMaster', 'branchM']), 201);
    }

    public function show($id)
    {
        $prtyMast = PrtyMast::with(['coMaster', 'branchM'])->findOrFail($id);
        return response()->json($prtyMast, 200);
    }

    public function update(Request $request, $id)
    {
        $prtyMast = PrtyMast::findOrFail($id);
        $validator = Validator::make($request->all(), [
            'Co_Id' => 'required|integer|exists:co_masters,Co_Id',
            'Br_Id' => 'required|integer|exists:branch_ms,Br_Id',
            'pr_code' => 'nullable|string|max:15',
            'pr_gr' => 'nullable|string|max:8',
            'an_id' => 'nullable|string|max:40',
            'pr_ct_id' => 'nullable|string|max:40',
            'pr_td_id' => 'nullable|string|max:40',
            'pr_fb_id' => 'nullable|string|max:40',
            'pr_bk_id' => 'nullable|string|max:40',
            'pr_name' => 'nullable|string|max:40',
            'pr_ad_pr_no' => 'nullable|string|max:7',
            'pr_ad_pr_nm' => 'nullable|string|max:20',
            'pr_ad_nr_lm' => 'nullable|string|max:20',
            'pr_ad_strt' => 'nullable|string|max:20',
            'pr_ar_id' => 'nullable|string|max:20',
            'pr_eml' => 'nullable|email|max:35',
            'pr_web' => 'nullable|url|max:35',
            'pr_ph' => 'nullable|string|max:35',
            'pr_cp' => 'nullable|string|max:35',
            'pr_ref' => 'nullable|string|max:30',
            'pr_hld' => 'nullable|string|max:1',
            'pr_rmk' => 'nullable|string|max:30',
            'pr_cr_l' => 'nullable|numeric',
            'pr_dp' => 'nullable|numeric',
            'pr_cr_d' => 'nullable|numeric',
            'pnl_int' => 'nullable|numeric',
            'pr_bl_p' => 'nullable|string|max:1',
            'pr_rpt' => 'nullable|string|max:1',
            'cq_clr' => 'nullable|numeric',
            'pr_st' => 'nullable|string|max:35',
            'pr_cst' => 'nullable|string|max:35',
            'pr_vat' => 'nullable|string|max:35',
            'pr_pa' => 'nullable|string|max:35',
            'pr_reg' => 'nullable|string|max:35',
            'pr_ecx' => 'nullable|string|max:35',
            'pr_ecc' => 'nullable|string|max:35',
            'pr_e_ad' => 'nullable|string|max:35',
            'pr_e_dv' => 'nullable|string|max:35',
            'pr_e_col' => 'nullable|string|max:35',
            'pr_e_rng' => 'nullable|string|max:35',
            'pr_e_ra1' => 'nullable|string|max:35',
            'pr_trn' => 'nullable|string|max:20',
            'pr_sub' => 'nullable|string|max:1',
            'tallydata' => 'nullable|string|max:50',
            'sn_func_id' => 'nullable|numeric',
            'sb_func' => 'nullable|string|max:20',
            'pr_bl_t' => 'nullable|string|max:1',
            'op_id' => 'nullable|integer',
            'dt_tm' => 'nullable|string|max:10',
            'opb_amt' => 'nullable|numeric',
            'cur_amt' => 'nullable|numeric',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $prtyMast->update($request->all());
        return response()->json($prtyMast->load(['coMaster', 'branchM']), 200);
    }

    public function destroy($id)
    {
        $prtyMast = PrtyMast::findOrFail($id);
        $prtyMast->delete();
        return response()->json(null, 204);
    }
}
