<?php

namespace App\Http\Controllers;

use App\Models\PollActionLog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PollActionLogController extends Controller
{
    /**
     * Get all PollActionLog records.
     */
    public function index()
    {
        $pollActionLogs = PollActionLog::with(['pollBook', 'user', 'pollAction'])->get();
        return response()->json($pollActionLogs);
    }

    /**
     * Get a specific PollActionLog record by PA_Sr.
     */
    public function show($id)
    {
        $pollActionLog = PollActionLog::with(['pollBook', 'user', 'pollAction'])->find($id);

        if (!$pollActionLog) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        return response()->json($pollActionLog);
    }

    /**
     * Create a new PollActionLog record.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'Poll_Id' => 'required|integer|exists:poll_book,Poll_Id',
            'U_ID'    => 'required|integer|exists:users_master,U_Id',
            'PA_Id'   => 'required|integer|exists:poll_action,PA_Id',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $pollActionLog = PollActionLog::create([
            'Poll_Id' => $request->input('Poll_Id'),
            'U_ID'    => $request->input('U_ID'),
            'PA_Id'   => $request->input('PA_Id'),
        ]);

        return response()->json($pollActionLog, 201);
    }

    /**
     * Update a PollActionLog record by PA_Sr.
     */
    public function update(Request $request, $id)
    {
        $pollActionLog = PollActionLog::find($id);

        if (!$pollActionLog) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        $validator = Validator::make($request->all(), [
            'Poll_Id' => 'required|integer|exists:poll_book,Poll_Id',
            'U_ID'    => 'required|integer|exists:users_master,U_Id',
            'PA_Id'   => 'required|integer|exists:poll_action,PA_Id',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $pollActionLog->update([
            'Poll_Id' => $request->input('Poll_Id'),
            'U_ID'    => $request->input('U_ID'),
            'PA_Id'   => $request->input('PA_Id'),
        ]);

        return response()->json($pollActionLog);
    }

    /**
     * Delete a PollActionLog record by PA_Sr.
     */
    public function destroy($id)
    {
        $pollActionLog = PollActionLog::find($id);

        if (!$pollActionLog) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        $pollActionLog->delete();
        return response()->json(['message' => 'Deleted successfully']);
    }
}
