<?php

namespace App\Http\Controllers;

use App\Models\ParkingType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ParkingTypeController extends Controller
{
    /**
     * Display a listing of the parking types.
     */
    public function index()
    {
        $parkingTypes = ParkingType::all();
        return response()->json([
            'message' => 'Parking types retrieved successfully',
            'data' => $parkingTypes,
        ], 200);
    }

    /**
     * Store a newly created parking type in storage.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'Type_Desc' => 'required|string|max:255|unique:parking_types,Type_Desc',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'error' => $validator->errors(),
            ], 422);
        }

        $parkingType = ParkingType::create([
            'Type_Desc' => $request->Type_Desc,
        ]);

        return response()->json([
            'message' => 'Parking type created successfully',
            'data' => $parkingType,
        ], 201);
    }

    /**
     * Display the specified parking type.
     */
    public function show($id)
    {
        $parkingType = ParkingType::find($id);

        if (!$parkingType) {
            return response()->json([
                'error' => 'Parking type not found',
            ], 404);
        }

        return response()->json([
            'message' => 'Parking type retrieved successfully',
            'data' => $parkingType,
        ], 200);
    }

    /**
     * Update the specified parking type in storage.
     */
    public function update(Request $request, $id)
    {
        $parkingType = ParkingType::find($id);

        if (!$parkingType) {
            return response()->json([
                'error' => 'Parking type not found',
            ], 404);
        }

        $validator = Validator::make($request->all(), [
            'Type_Desc' => 'required|string|max:255|unique:parking_types,Type_Desc,' . $id . ',PT_ID',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'error' => $validator->errors(),
            ], 422);
        }

        $parkingType->update([
            'Type_Desc' => $request->Type_Desc,
        ]);

        return response()->json([
            'message' => 'Parking type updated successfully',
            'data' => $parkingType,
        ], 200);
    }

    /**
     * Remove the specified parking type from storage.
     */
    public function destroy($id)
    {
        $parkingType = ParkingType::find($id);

        if (!$parkingType) {
            return response()->json([
                'error' => 'Parking type not found',
            ], 404);
        }

        $parkingType->delete();

        return response()->json([
            'message' => 'Parking type deleted successfully',
        ], 200);
    }
}
