<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\PackageMaster;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class PackageMasterController extends Controller
{
    public function index(): JsonResponse
    {
        $packageMasters = PackageMaster::all();
        return response()->json(['data' => $packageMasters], 200);
    }

    public function store(Request $request): JsonResponse
    {
        $validated = $request->validate([
            'PackageName' => 'required|string|max:25',
            'Description' => 'required|string|max:25',
            'Status' => 'required|string|in:A,I|max:1',
            'PackFixPrice' => 'required|numeric|min:0',
            'PackFreeUsers' => 'required|integer|min:0',
            'ExtraUserFees' => 'required|numeric|min:0',
            'ValidityDays' => 'required|integer|min:1',
            'AutoRenew' => 'required|string|in:Y,N|max:1',
        ]);

        $packageMaster = PackageMaster::create($validated);
        return response()->json(['data' => $packageMaster, 'message' => 'Package created successfully'], 201);
    }

    public function show($id): JsonResponse
    {
        $packageMaster = PackageMaster::findOrFail($id);
        return response()->json(['data' => $packageMaster], 200);
    }

    public function update(Request $request, $id): JsonResponse
    {
        $packageMaster = PackageMaster::findOrFail($id);
        $validated = $request->validate([
            'PackageName' => 'required|string|max:25',
            'Description' => 'required|string|max:25',
            'Status' => 'required|string|in:A,I|max:1',
            'PackFixPrice' => 'required|numeric|min:0',
            'PackFreeUsers' => 'required|integer|min:0',
            'ExtraUserFees' => 'required|numeric|min:0',
            'ValidityDays' => 'required|integer|min:1',
            'AutoRenew' => 'required|string|in:Y,N|max:1',
        ]);

        $packageMaster->update($validated);
        return response()->json(['data' => $packageMaster, 'message' => 'Package updated successfully'], 200);
    }

    public function destroy($id): JsonResponse
    {
        $packageMaster = PackageMaster::findOrFail($id);
        $packageMaster->delete();
        return response()->json(['message' => 'Package deleted successfully'], 200);
    }
}
