<?php

namespace App\Http\Controllers;

use App\Models\NoticeCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class NoticeCategoryController extends Controller
{
    /**
     * Get all NoticeCategory records.
     */
    public function index()
    {
        $noticeCategories = NoticeCategory::all();
        return response()->json($noticeCategories);
    }

    /**
     * Get a specific NoticeCategory record by Nc_Id.
     */
    public function show($id)
    {
        $noticeCategory = NoticeCategory::find($id);

        if (!$noticeCategory) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        return response()->json($noticeCategory);
    }

    /**
     * Create a new NoticeCategory record.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'Nc_Desc' => 'required|string|max:25', // Validate description
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $noticeCategory = NoticeCategory::create([
            'Nc_Desc' => $request->input('Nc_Desc'),
        ]);

        return response()->json($noticeCategory, 201);
    }

    /**
     * Update a NoticeCategory record by Nc_Id.
     */
    public function update(Request $request, $id)
    {
        $noticeCategory = NoticeCategory::find($id);

        if (!$noticeCategory) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        $validator = Validator::make($request->all(), [
            'Nc_Desc' => 'required|string|max:25', // Validate description
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $noticeCategory->update([
            'Nc_Desc' => $request->input('Nc_Desc'),
        ]);

        return response()->json($noticeCategory);
    }

    /**
     * Delete a NoticeCategory record by Nc_Id.
     */
    public function destroy($id)
    {
        $noticeCategory = NoticeCategory::find($id);

        if (!$noticeCategory) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        $noticeCategory->delete();
        return response()->json(['message' => 'Deleted successfully']);
    }
}
