<?php

namespace App\Http\Controllers;

use App\Models\NoticeActionLog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class NoticeActionLogController extends Controller
{
    /**
     * Get all NoticeActionLog records.
     */
    public function index()
{
    $logs = NoticeActionLog::with(['noticeBoard', 'user', 'noticeAction'])->get();
    return response()->json($logs);
}

/**
 * Get a specific NoticeActionLog record by NA_Sr.
 */
public function show($id)
{
    $log = NoticeActionLog::with(['noticeBoard', 'user', 'noticeAction'])->find($id);

    if (!$log) {
        return response()->json(['message' => 'Record not found'], 404);
    }

    return response()->json($log);
}

    /**
     * Create a new NoticeActionLog record.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'Ntc_Id' => 'required|integer|exists:notice_board,Ntc_Id',
            'U_Id'   => 'required|integer|exists:users_master,U_Id',
            'NA_Id'  => 'required|integer|exists:notice_action,NA_Id',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $log = NoticeActionLog::create([
            'Ntc_Id' => $request->Ntc_Id,
            'U_Id'   => $request->U_Id,
            'NA_Id'  => $request->NA_Id,
        ]);

        return response()->json($log, 201);
    }

    /**
     * Update a NoticeActionLog record by NA_Sr.
     */
    public function update(Request $request, $id)
    {
        $log = NoticeActionLog::find($id);

        if (!$log) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        $validator = Validator::make($request->all(), [
            'Ntc_Id' => 'required|integer|exists:notice_board,Ntc_Id',
            'U_Id'   => 'required|integer|exists:users_master,U_Id',
            'NA_Id'  => 'required|integer|exists:notice_action,NA_Id',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $log->update([
            'Ntc_Id' => $request->Ntc_Id,
            'U_Id'   => $request->U_Id,
            'NA_Id'  => $request->NA_Id,
        ]);

        return response()->json($log);
    }

    /**
     * Delete a NoticeActionLog record by NA_Sr.
     */
    public function destroy($id)
    {
        $log = NoticeActionLog::find($id);

        if (!$log) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        $log->delete();
        return response()->json(['message' => 'Deleted successfully']);
    }
}
