<?php

namespace App\Http\Controllers;

use App\Models\NoticeAction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class NoticeActionController extends Controller
{
    /**
     * Get all NoticeAction records.
     */
    public function index()
    {
        $noticeActions = NoticeAction::all();
        return response()->json($noticeActions);
    }

    /**
     * Get a specific NoticeAction record by NA_Id.
     */
    public function show($id)
    {
        $noticeAction = NoticeAction::find($id);

        if (!$noticeAction) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        return response()->json($noticeAction);
    }

    /**
     * Create a new NoticeAction record.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'Na_Desc' => 'required|string|max:255', // Validate description
            'Na_Flag' => 'required|string|max:1',  // Flag to indicate status
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $noticeAction = NoticeAction::create([
            'Na_Desc' => $request->input('Na_Desc'),
            'Na_Flag' => $request->input('Na_Flag'),
        ]);

        return response()->json($noticeAction, 201);
    }

    /**
     * Update a NoticeAction record by NA_Id.
     */
    public function update(Request $request, $id)
    {
        $noticeAction = NoticeAction::find($id);

        if (!$noticeAction) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        $validator = Validator::make($request->all(), [
            'Na_Desc' => 'required|string|max:255',
            'Na_Flag' => 'required|string|max:1',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $noticeAction->update([
            'Na_Desc' => $request->input('Na_Desc'),
            'Na_Flag' => $request->input('Na_Flag'),
        ]);

        return response()->json($noticeAction);
    }

    /**
     * Delete a NoticeAction record by NA_Id.
     */
    public function destroy($id)
    {
        $noticeAction = NoticeAction::find($id);

        if (!$noticeAction) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        $noticeAction->delete();
        return response()->json(['message' => 'Deleted successfully']);
    }
}
