<?php

namespace App\Http\Controllers;

use App\Models\LedgGrp;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class LedgGrpController extends Controller
{
    public function index()
    {
        return response()->json(LedgGrp::with('coMaster')->get(), 200);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'Co_Id' => 'nullable|integer|exists:co_masters,Co_Id',
            'gr_code' => 'nullable|string|max:8',
            'up_gr' => 'nullable|string|max:25',
            'gr_nm' => 'nullable|string|max:75',
            'gr_sr' => 'nullable|numeric',
            'gr_alt' => 'nullable|string|max:15',
            'gr_stt' => 'nullable|numeric',
            'gr_al_c' => 'nullable|string|max:75',
            'GIFI_Code' => 'nullable|string|max:10',
            'is_del' => 'nullable|string',
            'gr_exp' => 'nullable|string|max:1',
            'gr_buk' => 'nullable|string|max:1',
            'gr_prt' => 'nullable|string|max:1',
            'op_id' => 'nullable|integer',
            'dt_tm' => 'nullable|string|max:10',
            'naof_grp' => 'nullable|string|max:10',
            'credition' => 'nullable|string|max:50',
            'eff_gp' => 'nullable|string|max:50',
            'eff_sub_led' => 'nullable|string|max:50',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $ledgGrp = LedgGrp::create($request->all());
        return response()->json($ledgGrp->load('coMaster'), 201);
    }

    public function show($id)
    {
        $ledgGrp = LedgGrp::with('coMaster')->findOrFail($id);
        return response()->json($ledgGrp, 200);
    }

    public function update(Request $request, $id)
    {
        $ledgGrp = LedgGrp::findOrFail($id);
        $validator = Validator::make($request->all(), [
            'Co_Id' => 'nullable|integer|exists:co_masters,Co_Id',
            'gr_code' => 'nullable|string|max:8',
            'up_gr' => 'nullable|string|max:25',
            'gr_nm' => 'nullable|string|max:75',
            'gr_sr' => 'nullable|numeric',
            'gr_alt' => 'nullable|string|max:15',
            'gr_stt' => 'nullable|numeric',
            'gr_al_c' => 'nullable|string|max:75',
            'GIFI_Code' => 'nullable|string|max:10',
            'is_del' => 'nullable|string',
            'gr_exp' => 'nullable|string|max:1',
            'gr_buk' => 'nullable|string|max:1',
            'gr_prt' => 'nullable|string|max:1',
            'op_id' => 'nullable|integer',
            'dt_tm' => 'nullable|string|max:10',
            'naof_grp' => 'nullable|string|max:10',
            'credition' => 'nullable|string|max:50',
            'eff_gp' => 'nullable|string|max:50',
            'eff_sub_led' => 'nullable|string|max:50',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $ledgGrp->update($request->all());
        return response()->json($ledgGrp->load('coMaster'), 200);
    }

    public function destroy($id)
    {
        $ledgGrp = LedgGrp::findOrFail($id);
        $ledgGrp->delete();
        return response()->json(null, 204);
    }
}
