<?php

namespace App\Http\Controllers;

use App\Models\GuardCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class GuardCategoryController extends Controller
{
    /**
     * Get all GuardCategory records.
     */
    public function index()
    {
        $guardCategories = GuardCategory::all(); // Get all categories
        return response()->json($guardCategories);
    }

    /**
     * Get a specific GuardCategory record by GC_Id.
     */
    public function show($id)
    {
        $guardCategory = GuardCategory::find($id);  // Find by ID

        if (!$guardCategory) {
            return response()->json(['message' => 'Record not found'], 404);  // Not found response
        }

        return response()->json($guardCategory);
    }

    /**
     * Create a new GuardCategory record.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'GC_Name' => 'required|string|max:25',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);  // Validation failed
        }

        $guardCategory = GuardCategory::create([
            'GC_Name' => $request->input('GC_Name'),
        ]);

        return response()->json($guardCategory, 201);  // Created response
    }

    /**
     * Update a GuardCategory record by GC_Id.
     */
    public function update(Request $request, $id)
    {
        $guardCategory = GuardCategory::find($id);  // Find by ID

        if (!$guardCategory) {
            return response()->json(['message' => 'Record not found'], 404);  // Not found response
        }

        $validator = Validator::make($request->all(), [
            'GC_Name' => 'required|string|max:25',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);  // Validation failed
        }

        $guardCategory->update([
            'GC_Name' => $request->input('GC_Name'),
        ]);

        return response()->json($guardCategory);  // Updated response
    }

    /**
     * Delete a GuardCategory record by GC_Id.
     */
    public function destroy($id)
    {
        $guardCategory = GuardCategory::find($id);  // Find by ID

        if (!$guardCategory) {
            return response()->json(['message' => 'Record not found'], 404);  // Not found response
        }

        $guardCategory->delete();  // Delete the record

        return response()->json(['message' => 'Deleted successfully']);  // Success response
    }
}
