<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\DiscountType;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class DiscountTypeController extends Controller
{
    public function index(): JsonResponse
    {
        $discountTypes = DiscountType::all();
        return response()->json(['data' => $discountTypes], 200);
    }

    public function store(Request $request): JsonResponse
    {
        $validated = $request->validate([
            'DiscountType' => 'required|string|max:255',
        ]);

        $discountType = DiscountType::create($validated);
        return response()->json(['data' => $discountType, 'message' => 'Discount Type created successfully'], 201);
    }

    public function show($id): JsonResponse
    {
        $discountType = DiscountType::findOrFail($id);
        return response()->json(['data' => $discountType], 200);
    }

    public function update(Request $request, $id): JsonResponse
    {
        $discountType = DiscountType::findOrFail($id);
        $validated = $request->validate([
            'DiscountType' => 'required|string|max:255',
        ]);

        $discountType->update($validated);
        return response()->json(['data' => $discountType, 'message' => 'Discount Type updated successfully'], 200);
    }

    public function destroy($id): JsonResponse
    {
        $discountType = DiscountType::findOrFail($id);
        $discountType->delete();
        return response()->json(['message' => 'Discount Type deleted successfully'], 200);
    }
}
