<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\DiscountMaster;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class DiscountMasterController extends Controller
{
    public function index(): JsonResponse
    {
        $discountMasters = DiscountMaster::with(['discountType', 'discountCriteria', 'discountCondition', 'discountUnit'])->get();
        return response()->json(['data' => $discountMasters], 200);
    }

    public function store(Request $request): JsonResponse
    {
        $validated = $request->validate([
            'DiscTID' => 'required|exists:discount_types,DiscTID',
            'DiscountName' => 'required|string|max:25',
            'DiscCriID' => 'required|exists:disc_crieterias,DiscCriID',
            'Cri_Vale' => 'required|numeric|min:0',
            'Disc_Value' => 'required|numeric|min:0',
            'DiscCMast' => 'required|exists:disc_cond_masts,DiscCMast',
            'DiscUId' => 'required|exists:disc_units,DiscUID',
            'D_Valid_From' => 'required|date_format:Y-m-d',
            'D_Valid_To' => 'required|date_format:Y-m-d|after:D_Valid_From',
            'D_Apply_To' => 'required|string|max:25',
            'Disc_Clubbed' => 'required|string|in:Y,N|max:1',
            'Status' => 'required|string|in:A,I|max:1',
        ]);

        $discountMaster = DiscountMaster::create($validated);
        return response()->json(['data' => $discountMaster, 'message' => 'Discount created successfully'], 201);
    }

    public function show($id): JsonResponse
    {
        $discountMaster = DiscountMaster::with(['discountType', 'discountCriteria', 'discountCondition', 'discountUnit'])->findOrFail($id);
        return response()->json(['data' => $discountMaster], 200);
    }

    public function update(Request $request, $id): JsonResponse
    {
        $discountMaster = DiscountMaster::findOrFail($id);
        $validated = $request->validate([
            'DiscTID' => 'required|exists:discount_types,DiscTID',
            'DiscountName' => 'required|string|max:25',
            'DiscCriID' => 'required|exists:disc_crieterias,DiscCriID',
            'Cri_Vale' => 'required|numeric|min:0',
            'Disc_Value' => 'required|numeric|min:0',
            'DiscCMast' => 'required|exists:disc_cond_masts,DiscCMast',
            'DiscUId' => 'required|exists:disc_units,DiscUID',
            'D_Valid_From' => 'required|date_format:Y-m-d',
            'D_Valid_To' => 'required|date_format:Y-m-d|after:D_Valid_From',
            'D_Apply_To' => 'required|string|max:25',
            'Disc_Clubbed' => 'required|string|in:Y,N|max:1',
            'Status' => 'required|string|in:A,I|max:1',
        ]);

        $discountMaster->update($validated);
        return response()->json(['data' => $discountMaster, 'message' => 'Discount updated successfully'], 200);
    }

    public function destroy($id): JsonResponse
    {
        $discountMaster = DiscountMaster::findOrFail($id);
        $discountMaster->delete();
        return response()->json(['message' => 'Discount deleted successfully'], 200);
    }
}
