<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\DiscUnit;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class DiscUnitController extends Controller
{
    public function index(): JsonResponse
    {
        $discUnits = DiscUnit::all();
        return response()->json(['data' => $discUnits], 200);
    }

    public function store(Request $request): JsonResponse
    {
        $validated = $request->validate([
            'Disc_Unit_Desc' => 'required|string|max:255',
        ]);

        $discUnit = DiscUnit::create($validated);
        return response()->json(['data' => $discUnit, 'message' => 'Discount Unit created successfully'], 201);
    }

    public function show($id): JsonResponse
    {
        $discUnit = DiscUnit::findOrFail($id);
        return response()->json(['data' => $discUnit], 200);
    }

    public function update(Request $request, $id): JsonResponse
    {
        $discUnit = DiscUnit::findOrFail($id);
        $validated = $request->validate([
            'Disc_Unit_Desc' => 'required|string|max:255',
        ]);

        $discUnit->update($validated);
        return response()->json(['data' => $discUnit, 'message' => 'Discount Unit updated successfully'], 200);
    }

    public function destroy($id): JsonResponse
    {
        $discUnit = DiscUnit::findOrFail($id);
        $discUnit->delete();
        return response()->json(['message' => 'Discount Unit deleted successfully'], 200);
    }
}
