<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\DiscCrieteria;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class DiscCrieteriaController extends Controller
{
    public function index(): JsonResponse
    {
        $discCrieterias = DiscCrieteria::all();
        return response()->json(['data' => $discCrieterias], 200);
    }

    public function store(Request $request): JsonResponse
    {
        $validated = $request->validate([
            'DiscountCriteria' => 'required|string|max:255',
        ]);

        $discCrieteria = DiscCrieteria::create($validated);
        return response()->json(['data' => $discCrieteria, 'message' => 'Discount Criteria created successfully'], 201);
    }

    public function show($id): JsonResponse
    {
        $discCrieteria = DiscCrieteria::findOrFail($id);
        return response()->json(['data' => $discCrieteria], 200);
    }

    public function update(Request $request, $id): JsonResponse
    {
        $discCrieteria = DiscCrieteria::findOrFail($id);
        $validated = $request->validate([
            'DiscountCriteria' => 'required|string|max:255',
        ]);

        $discCrieteria->update($validated);
        return response()->json(['data' => $discCrieteria, 'message' => 'Discount Criteria updated successfully'], 200);
    }

    public function destroy($id): JsonResponse
    {
        $discCrieteria = DiscCrieteria::findOrFail($id);
        $discCrieteria->delete();
        return response()->json(['message' => 'Discount Criteria deleted successfully'], 200);
    }
}
