<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\DiscCondMast;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class DiscCondMastController extends Controller
{
    public function index(): JsonResponse
    {
        $discCondMasts = DiscCondMast::all();
        return response()->json(['data' => $discCondMasts], 200);
    }

    public function store(Request $request): JsonResponse
    {
        $validated = $request->validate([
            'DiscCondDesc' => 'required|string|max:255',
            'DiscC_Value' => 'required|string|max:25',
        ]);

        $discCondMast = DiscCondMast::create($validated);
        return response()->json(['data' => $discCondMast, 'message' => 'Discount Condition created successfully'], 201);
    }

    public function show($id): JsonResponse
    {
        $discCondMast = DiscCondMast::findOrFail($id);
        return response()->json(['data' => $discCondMast], 200);
    }

    public function update(Request $request, $id): JsonResponse
    {
        $discCondMast = DiscCondMast::findOrFail($id);
        $validated = $request->validate([
            'DiscCondDesc' => 'required|string|max:255',
            'DiscC_Value' => 'required|string|max:25',
        ]);

        $discCondMast->update($validated);
        return response()->json(['data' => $discCondMast, 'message' => 'Discount Condition updated successfully'], 200);
    }

    public function destroy($id): JsonResponse
    {
        $discCondMast = DiscCondMast::findOrFail($id);
        $discCondMast->delete();
        return response()->json(['message' => 'Discount Condition deleted successfully'], 200);
    }
}
