<?php

namespace App\Http\Controllers;

use App\Models\CompCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class CompCategoryController extends Controller
{
    /**
     * Get all CompCategory records.
     */
    public function index()
    {
        $compCategories = CompCategory::all();  // Get all categories
        return response()->json($compCategories);
    }

    /**
     * Get a specific CompCategory record by CC_Id.
     */
    public function show($id)
    {
        $compCategory = CompCategory::find($id);

        if (!$compCategory) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        return response()->json($compCategory);
    }

    /**
     * Create a new CompCategory record.
     */
    public function store(Request $request)
    {
        // Validate request data
        $validator = Validator::make($request->all(), [
            'CC_Desc' => 'required|string|max:100',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        // Create a new category
        $compCategory = CompCategory::create([
            'CC_Desc' => $request->input('CC_Desc'),
        ]);

        return response()->json($compCategory, 201);
    }

    /**
     * Update a CompCategory record by CC_Id.
     */
    public function update(Request $request, $id)
    {
        $compCategory = CompCategory::find($id);

        if (!$compCategory) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        // Validate request data
        $validator = Validator::make($request->all(), [
            'CC_Desc' => 'required|string|max:100',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        // Update the category
        $compCategory->update([
            'CC_Desc' => $request->input('CC_Desc'),
        ]);

        return response()->json($compCategory);
    }

    /**
     * Delete a CompCategory record by CC_Id.
     */
    public function destroy($id)
    {
        $compCategory = CompCategory::find($id);

        if (!$compCategory) {
            return response()->json(['message' => 'Record not found'], 404);
        }

        $compCategory->delete();  // Delete the category
        return response()->json(['message' => 'Deleted successfully']);
    }
}
