<?php

namespace App\Http\Controllers;

use App\Models\AmenityMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class AmenityMasterController extends Controller
{
    /**
     * Get all AmenityMaster records.
     */
    public function index()
    {
        $amenities = AmenityMaster::all();
        return response()->json($amenities);
    }

    /**
     * Get a specific AmenityMaster record by AM_ID.
     */
    public function show($id)
    {
        $amenity = AmenityMaster::find($id);

        if (!$amenity) {
            return response()->json(['message' => 'Amenity not found'], 404);
        }

        return response()->json($amenity);
    }

    /**
     * Create a new AmenityMaster record.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'AM_Desc' => 'required|string|max:25',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $amenity = AmenityMaster::create([
            'AM_Desc' => $request->input('AM_Desc'),
        ]);

        return response()->json($amenity, 201);
    }

    /**
     * Update an AmenityMaster record by AM_ID.
     */
    public function update(Request $request, $id)
    {
        $amenity = AmenityMaster::find($id);

        if (!$amenity) {
            return response()->json(['message' => 'Amenity not found'], 404);
        }

        $validator = Validator::make($request->all(), [
            'AM_Desc' => 'nullable|string|max:25',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        if ($request->has('AM_Desc')) {
            $amenity->AM_Desc = $request->input('AM_Desc');
            $amenity->save();
        }

        return response()->json($amenity);
    }

    /**
     * Delete an AmenityMaster record by AM_ID.
     */
    public function delete($id)
    {
        $amenity = AmenityMaster::find($id);

        if (!$amenity) {
            return response()->json(['message' => 'Amenity not found'], 404);
        }

        $amenity->delete();
        return response()->json(['message' => 'Amenity deleted successfully']);
    }
}
